#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:1
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=9
#SBATCH --job-name=Places-LP
#SBATCH --time=120:00:00
#SBATCH --mem=120G
#SBATCH --constraint=v100|rtx6k|rtx8k|p40
#SBATCH --exclude=gnodee8,gnodec1



PYTHON='/scratch/shared/beegfs/yuki/envs/py37/bin/python3'

tar xf /scratch/shared/beegfs/yuki/data/Places.tar -C ${TMPDIR}
DATASET_PATH=${TMPDIR}/Places

EXP_STR=$1


EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
MODEL_STR=${EXPERIMENT_PATH}/checkpoint.pth.tar
mkdir -p $EXPERIMENT_PATH/LP_places

echo "will use" ${MODEL_STR}

CUDA_VISIBLE_DEVICES=0 ${PYTHON} main_lincls.py \
            -a resnet50 \
            --dataset 'places205' \
            --lr 30.0 \
            --batch-size 256 \
            --pretrained ${MODEL_STR} \
            --resume ${EXPERIMENT_PATH}/LP_places/checkpoint.pth.tar \
            --dump_path ${EXPERIMENT_PATH}/LP_places \
            ${DATASET_PATH} 2>&1 | tee -a ${EXPERIMENT_PATH}/log_LP_places.txt